/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model;

import com.aptana.js.debug.core.internal.model.JSDebugElement;
import com.aptana.js.debug.core.internal.model.JSDebugTarget;
import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class JSDebugValue
extends JSDebugElement
implements IValue {
    private final String threadId;
    private final String qualifier;
    private final String typeName;
    private boolean hasVariables;
    private final String valueString;
    private IVariable[] variables;

    public JSDebugValue(IDebugTarget target, String threadId, String qualifier, String typeName, boolean hasVariables, String valueString) {
        super(target);
        this.threadId = threadId;
        this.qualifier = qualifier;
        this.typeName = typeName;
        this.hasVariables = hasVariables;
        this.valueString = valueString;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.typeName;
    }

    public String getValueString() throws DebugException {
        return this.valueString != null ? this.valueString : MessageFormat.format("'''{'{0}}", this.typeName);
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.hasVariables) {
            this.getVariables0();
        }
        return this.variables != null ? this.variables : new IVariable[]{};
    }

    public boolean hasVariables() throws DebugException {
        return this.hasVariables;
    }

    String getQualifier() {
        return this.qualifier;
    }

    String getThreadId() {
        return this.threadId;
    }

    private void getVariables0() throws DebugException {
        if (this.variables == null) {
            this.variables = ((JSDebugTarget)this.getDebugTarget()).loadVariables(this.threadId, this.qualifier);
            this.hasVariables = this.variables != null && this.variables.length > 0;
        }
    }
}

